unit DataModule;

interface

uses
  SysUtils, Classes, DB, IBDatabase, Dialogs, IBCustomDataSet, IBQuery,
  IBTable, IBStoredProc;

type
  TDM = class(TDataModule)
    IBDatabase: TIBDatabase;
    IBTransaction: TIBTransaction;
    TableOsoby: TIBTable;
    dsOsoby: TDataSource;
    IBTransaction1: TIBTransaction;
    TableOsobyIDOSOBY: TIntegerField;
    TableOsobyNAZWISKO: TIBStringField;
    TableOsobyIMIE: TIBStringField;
    TableOsobyDATAUR: TDateField;
    TableOsobyMCOWOSC: TIBStringField;
    TableOsobyULICAINR: TIBStringField;
    TableOsobyKODP: TIBStringField;
    TableOsobyMIASTO: TIBStringField;
    TableOsobyPESEL: TIBStringField;
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
    procedure QueryOsobyDATAURGetText(Sender: TField; var Text: String; DisplayText: Boolean);
    procedure IBTableOsobyKODPSetText(Sender: TField; const Text: String);
    procedure TableOsobyKODPSetText(Sender: TField; const Text: String);

  private

  public

  end;

var
  DM: TDM;

implementation
{$R *.dfm}

Uses
   DateUtils, 
   Variants;


procedure TDM.DataModuleCreate(Sender: TObject);
begin
   if not IBDataBase.Connected then
   begin
      IBDatabase.Connected := True;
      // lub: IBDatabase.Open();
   end;
   TableOsoby.Open();
end;

procedure TDM.DataModuleDestroy(Sender: TObject);
begin
   if IBDataBase.Connected then
   begin
      IBDatabase.Connected := False;
      // lub: IBDatabase.Close();
   end;
   TableOsoby.Close();   
end;

procedure TDM.QueryOsobyDATAURGetText(Sender: TField;
                                      var Text: String;
                                      DisplayText: Boolean);
var
   Pole    : Variant;
// DataUr  : TDateTime;
   DataUr  : Variant;
   Dzisiaj : TDateTime;
   Roznica : Integer;

begin
(*
   Pole := Sender.Value;

   if VarIsNull(Pole) then
   begin
      Text := 'Do ustalania';
   end
   else begin
      DataUr  := Pole;
      Dzisiaj := Now();
      Roznica := YearsBetween(Dzisiaj, DataUr);
      Text    := 'wiek ' + IntToStr(Roznica) + ' lat, data ur. ' + DateToStr(DataUr);
   end;
*)

   // lub druga wersja z polem DataUr : Variant

   DataUr := Sender.Value;

   if VarIsNull(DataUr) then
   begin
      Text := 'Do ustalania';
   end
   else begin
      Dzisiaj := Now();
      Roznica := YearsBetween(Dzisiaj, DataUr);
      Text    := 'wiek ' + IntToStr(Roznica) + ' lat, data ur. ' + DateToStr(DataUr);
   end;
end;

procedure TDM.IBTableOsobyKODPSetText(Sender: TField; const Text: String);
begin
   ShowMessage('OnSetText');
end;

procedure TDM.TableOsobyKODPSetText(Sender: TField; const Text: String);
var
   pole : Variant;
   ss   : String;

begin
   pole := VarToStr(TableOsobyKODP.Value);

   if not VarIsNull(pole) then
   begin
      ss   := Pole;

      if Pos('-', ss) = 0 then
      begin
         ShowMessage('Niepoprawna posta pola KOD P.');
      end;
   end;
end;

end.

